<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>Journey - Register</title>

    <!-- Custom fonts for this template-->
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">

</head>

<body class="bg-gradient-primary">

    <div class="container" align="center">
        <?php if (session()->has('error')) : ?>
            <div class="alert alert-danger mt-2 border-0 shadow-lg col-lg-6">
                <?= session('error') ?>
            </div>
        <?php endif; ?>
        <div class="card o-hidden border-0 shadow-lg my-5 col-lg-6">
            <div class="card-body p-0">

                <!-- Nested Row within Card Body -->
                <div class="row">
                    <div class="col-lg-12">
                        <div class="p-5">
                            <div class="text-center">
                                <h1 class="h4 text-gray-900 mb-4">Daftar Akun <img src="<?= base_url('img/Journey-login.png') ?>" width="150px" alt="">!</h1>
                            </div>
                            <form action="<?= site_url('register/submit') ?>" method="post" class="user">
                                <div class="form-group row">
                                    <div class="col-sm-12 mb-3 mb-sm-2">
                                        <input type="text" class="form-control form-control-user" id="full_name" name="full_name" placeholder="Nama Lengkap">
                                    </div>
                                    <div class="col-sm-12 mb-3 mb-sm-2">
                                        <input type="email" class="form-control form-control-user" id="email" name="email" placeholder="Surel">
                                    </div>
                                    <div class="col-sm-12 mb-3 mb-sm-2">
                                        <input type="password" class="form-control form-control-user" name="password" id="password" placeholder="Password">
                                    </div>

                                    <div class="col-sm-12 mb-3 mb-sm-2">
                                        <textarea type="textarea" class="form-control rounded-pill ukuran-font" name="address" id="address" placeholder="Alamat Lengkap"></textarea>
                                    </div>
                                    <div class="col-sm-6 mb-3 mb-sm-2">
                                        <input type="number" class="form-control form-control-user" name="age" id="age" placeholder="Umur">
                                    </div>
                                    <div class="col-sm-6 mb-3 mb-sm-2">
                                        <input type="text" class="form-control form-control-user" name="phone_number" id="phone_number" placeholder="Nomor Telepon">
                                    </div>
                                    <div class="col-sm-6 mb-3 mb-sm-2">
                                        <select class="form-control rounded-pill select-kustom ukuran-font" name="skill_one" id="skill_one">
                                            <option>Pilih Kemampuan Satu</option>
                                            <?php foreach ($skil as $sk) : ?>
                                                <option value="<?= $sk['id'] ?>"><?= $sk['name'] ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="col-sm-6 mb-3 mb-sm-2">
                                        <select class="form-control rounded-pill select-kustom ukuran-font" name="skill_two" id="skill_two">
                                            <option>Pilih Kemampuan Dua</option>
                                            <?php foreach ($skil as $sk) : ?>
                                                <option value="<?= $sk['id'] ?>"><?= $sk['name'] ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="col-sm-6 mb-3 mb-sm-2">
                                        <select class="form-control rounded-pill select-kustom ukuran-font" name="id_interest" id="id_interest">
                                            <option>Pilih Minat</option>
                                            <?php foreach ($interest as $inter) : ?>
                                                <option value="<?= $inter['id'] ?>"><?= $inter['name'] ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="col-sm-6 mb-3 mb-sm-2">
                                        <select class="form-control rounded-pill select-kustom ukuran-font" id="education" name="education">
                                            <option>Pendidikan Terakhir</option>
                                            <option value="SD">SD</option>
                                            <option value="SMP">SMP</option>
                                            <option value="SMK/SMA">SMK/SMA</option>
                                            <option value="S1">S1</option>
                                            <option value="S2">S2</option>
                                            <option value="S3">S3</option>
                                        </select>
                                    </div>
                                    <div class="col-sm-6 mb-3 mb-sm-2">
                                        <select class="form-control rounded-pill select-kustom ukuran-font" name="gender" required>
                                            <option>Jenis Kelamin</option>
                                            <option value="Laki-Laki">Laki-Laki</option>
                                            <option value="Perempuan">Perempuan</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <input class="btn btn-primary btn-user btn-block" type="submit" value="Register">
                            </form>
                            <hr>
                            <div class="text-center">
                                <a class="small" href="login">Sudah Punya Akun? Login!</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <!-- Bootstrap core JavaScript-->
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="js/sb-admin-2.min.js"></script>

</body>

</html>