<?= $this->extend('template/index'); ?>
<?= $this->section('content'); ?>
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-primary">Lowongan Populer</h1>
</div>
<div class="row">
    <?php if (is_array($vacancies) && !empty($vacancies)) : ?>
        <?php foreach ($vacancies as $vacancy) : ?>
            <div class="col-xl-4 col-md-6 mb-4">
                <a href="<?= site_url('detail_vacancy_with_company/' . $vacancy->id) ?>" class="text-decoration-none">
                    <div class="card shadow h-100 border-left-primary">
                        <div class="card-body d-flex flex-column">
                            <div class="d-flex align-items-center mb-3">
                                <img src="<?= htmlspecialchars($vacancy->company_logo, ENT_QUOTES, 'UTF-8') ?>" class="company-logo mr-3" alt="Company Logo">
                                <div>
                                    <h5 class="card-title text-primary mb-1"><?= htmlspecialchars($vacancy->placement_address, ENT_QUOTES, 'UTF-8') ?></h5>
                                    <h6 class="card-subtitle mb-2 text-muted"><?= htmlspecialchars($vacancy->sector_name, ENT_QUOTES, 'UTF-8') ?></h6>
                                    <h6 class="card-subtitle mb-2 text-muted">
                                        <?php
                                        if ($vacancy->job_type == 1) {
                                            echo "Full-time";
                                        } elseif ($vacancy->job_type == 2) {
                                            echo "Part-time";
                                        } elseif ($vacancy->job_type == 3) {
                                            echo "Remote";
                                        } else {
                                            echo "Unknown";
                                        }
                                        ?>
                                    </h6>
                                </div>
                            </div>
                            <p class="card-text text-dark mb-3 flex-grow-1"><?= htmlspecialchars($vacancy->description, ENT_QUOTES, 'UTF-8') ?></p>
                            <div class="mt-auto">
                                <div class="mb-2">
                                    <span class="badge badge-primary"><?= htmlspecialchars($vacancy->skill_one_name, ENT_QUOTES, 'UTF-8') ?></span>
                                    <span class="badge badge-primary"><?= htmlspecialchars($vacancy->skill_two_name, ENT_QUOTES, 'UTF-8') ?></span>
                                    <span class="badge badge-primary"><?= htmlspecialchars($vacancy->interest_name, ENT_QUOTES, 'UTF-8') ?></span>
                                </div>
                                <?php
$deadline_time = htmlspecialchars($vacancy->deadline_time, ENT_QUOTES, 'UTF-8');
$display_text = substr($deadline_time, 0, 10);
?>
                                <p class="card-text mt-3"><strong>Tutup pada:</strong> <span class="text-danger"><?= htmlspecialchars($display_text, ENT_QUOTES, 'UTF-8') ?></span></p>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
        <?php endforeach; ?>
    <?php else : ?>
        <div class="col-12">
            <div class="alert alert-warning" role="alert">
                No vacancies available.
            </div>
        </div>
    <?php endif; ?>
</div>
<!-- Pagination -->
<nav aria-label="Page navigation example">
    <ul class="pagination justify-content-center">
        <?php for ($i = 1; $i <= $totalPages; $i++) : ?>
            <li class="page-item <?= $i == $currentPage ? 'active' : '' ?>">
                <a class="page-link" href="<?= site_url('vacancies?page=' . $i) ?>"><?= $i ?></a>
            </li>
        <?php endfor; ?>
    </ul>
</nav>
<?= $this->endSection(); ?>