<?= $this->extend('company/template/index'); ?>
<?= $this->section('content'); ?>

<h1>Profil</h1>

<div class="row">
    <div class="col-xl-4">
        <!-- Profile picture card-->
        <div class="card mb-4 mb-xl-0">
            <div class="card-header">Foto Profil</div>
            <div class="card-body text-center">
                <!-- Profile picture image-->
                <img class="img-account-profile rounded-circle mb-2" src="<?= $company->logo ?>" alt="" width="200px" height="200px" />
                <!-- Profile picture help block-->
                <!-- Profile picture upload button-->
                <form id="uploadForm" action="<?= site_url('user/upload-logo/' . $company->id) ?>" method="post" enctype="multipart/form-data" style="display: none;">
                    <input type="file" name="profile_photo_url" id="profile_photo_input" class="form-control">
                </form>
            </div>
        </div>
        <div class="card mb-4 mb-xl-0 mt-4">
            <div class="card-header">Akta</div>
            <div class="card-body text-center">
                <!-- Embed PDF CV-->
                <embed src="<?= $company->akta ?>" type="application/pdf" width="100%" height="200px" />
                <!-- CV help block-->
                <div class="small text-muted mb-4"><a href="<?= $company->akta ?>">Unduh</a></div>
                <!-- CV upload button-->
                <form id="uploadFormCV" action="<?= site_url('user/upload-cv/' . $company->id) ?>" method="post" enctype="multipart/form-data" style="display: none;">
                    <input type="file" name="cv" id="inputcv" class="form-control">
                </form>
            </div>
        </div>
    </div>

    <div class="col-xl-8">
        <!-- Account details card-->
        <div class="card mb-4">
            <div class="card-header">Account Details</div>
            <div class="card-body">
                <form action="<?= site_url('user/update/' . $company->id) ?>" method="post">
                    <!-- Form Row-->
                    <div class="row gx-3 mb-3">
                        <!-- Form Group (first name)-->
                        <div class="col-md-6">
                            <label class="small mb-1" for="full_name">Nama</label>
                            <input class="form-control" type="text" name="full_name" value="<?= $company->name ?>" disabled />
                        </div>
                        <!-- Form Group (last name)-->
                        <div class="col-md-6">
                            <label class="small mb-1" for="email">Surel</label>
                            <input class="form-control" type="email" name="email" value="<?= $company->email ?>" disabled />
                        </div>
                    </div>
                    <!-- Form Row        -->
                    <div class="row gx-3 mb-3">
                        <!-- Form Group (organization name)-->
                        <div class="col-md-6">
                            <label class="small mb-1" for="skill_one">Sektor Perusahaan</label>
                            <input class="form-control" type="text" name="skill_one" value="<?= $company->sector_name ?>" disabled />
                        </div>
                        <div class="col-md-6">
                            <label class="small mb-1" for="id_interest">Kota</label>
                            <input class="form-control" type="text" name="interest_name" value="<?= $company->city ?>" disabled />
                        </div>
                    </div>
                    <!-- Form Row        -->
                    <div class="row gx-3 mb-3">
                        <!-- Form Group (organization name)-->

                        <!-- Form Group (location)-->
                        <div class="col-md-6">
                            <label class="small mb-1" for="phone_number">Provinsi</label>
                            <input class="form-control" id="phone_number" type="tel" name="phone_number" value="<?= $company->province ?>" disabled />
                        </div>
                        <div class="col-md-6">
                            <label class="small mb-1" for="age">Jumlah Karyawan</label>
                            <input class="form-control" type="number" name="age" value="<?= $company->employees ?>" disabled />
                        </div>
                    </div>
                    <div class="row gx-3 mb-3">
                        <div class="col-md-6">
                            <label class="small mb-1" for="phone_number">Telepon</label>
                            <input class="form-control" id="phone_number" type="text" name="phone_number" value="<?= $company->phone_number ?>" disabled />
                        </div>
                    </div>
                    <!-- Form Group (email address)-->
                    <div class="mb-3">
                        <label class="small mb-1" for="address">Alamat</label>
                        <textarea class="form-control" id="address" name="address" disabled><?= $company->address ?></textarea>
                    </div>
                    <div class="d-flex">
                        <!-- <button class="btn btn-primary d-flex justify-content-end" type="submit">Simpan</button> -->
                        <a href="<?= site_url('/company/edit/' . $company->id) ?>" class="btn btn-warning">Edit</a>
                    </div>
                    <!-- Save changes button-->
                </form>
            </div>
        </div>
    </div>
</div>
<?= $this->section('page-js'); ?>
<script>
    $(document).ready(function() {
        // Trigger input file click when upload button is clicked
        $('#uploadButton').on('click', function() {
            $('#profile_photo_input').click();
        });

        // Submit the form when a file is selected
        $('#profile_photo_input').on('change', function() {
            if ($(this).val()) {
                var formData = new FormData($('#uploadForm')[0]);
                $.ajax({
                    url: $('#uploadForm').attr('action'),
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    beforeSend: function() {
                        $("#loadnya").show();
                    },
                    success: function(response) {
                        $("#loadnya").hide();
                        if (response.success) {
                            Swal.fire('Berhasil!', response.message, 'success').then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire('Berhasil!', response.message, 'success').then(() => {
                                location.reload();
                            });
                        }
                    },
                    error: function(xhr, status, error) {
                        $("#loadnya").hide();
                        Swal.fire('Error!', 'Terjadi kesalahan', 'error');
                    }
                });
            }
        });
    });
</script>
<?= $this->endSection(); ?>
<?= $this->endSection(); ?>