<?= $this->extend('company/template/index'); ?>
<?= $this->section('content'); ?>
<div class="container">
    <h1>Edit Lowongan</h1>
    <form action="<?= site_url('company/vacancy/update/' . $vacancy->id) ?>" method="post">
        <div class="row gx-4">
            <div class="col-lg-8">
                <div class="card mb-4">
                    <div class="card-header">Penempatan</div>
                    <div class="card-body"><input class="form-control" id="placement_address" name="placement_address" value="<?= $vacancy->placement_address ?>" /></div>
                </div>
                <div class="card mb-4">
                    <div class="card-header">Kemampuan</div>
                    <div class="card-body">
                        <div class="row gx-3">
                            <div class="col-md-6">
                                <select class="form-control" name="skill_one" id="skill_one">
                                    <?php foreach ($skill as $skil) : ?>
                                        <option value="<?= $skil['id'] ?>" <?= $vacancy->skill_one_name == $skil['name'] ? 'selected' : '' ?>><?= $skil['name'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <select class="form-control" name="skill_two" id="skill_two">
                                    <?php foreach ($skill as $skil) : ?>
                                        <option value="<?= $skil['id'] ?>" <?= $vacancy->skill_two_name == $skil['name'] ? 'selected' : '' ?>><?= $skil['name'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card mb-4">
                    <div class="card-header">Minat & Jenis Pekerjaan</div>
                    <div class="card-body">
                        <div class="row gx-3">
                            <div class="col-md-6">
                                <select class="form-control" name="id_interest" id="id_interest">
                                    <?php foreach ($interest as $inter) : ?>
                                        <option value="<?= $inter['id'] ?>" <?= $vacancy->interest_name == $inter['name'] ? 'selected' : '' ?>><?= $inter['name'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <select class="form-control" id="job_type" name="job_type" required>
                                    <option value="1">Full Time</option>
                                    <option value="2">Part Time</option>
                                    <option value="3">Remote</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card mb-4">
                    <div class="card-header">Gaji & Batas Waktu</div>
                    <div class="card-body">
                        <div class="row gx-3">
                            <div class="col-md-6">
                                <input type="number" class="form-control" placeholder="Masukan gaji" name="salary" id="salary" value="<?= $vacancy->salary ?>" required>
                            </div>
                            <div class="col-md-6">
                                <?php
                                // Mengubah format tanggal dari database ke format yang sesuai untuk input type date
                                $formattedDeadline = date('Y-m-d', strtotime($vacancy->deadline_time));
                                ?>
                                <input type="date" class="form-control" name="deadline_time" id="deadline_time" value="<?= $formattedDeadline ?>" />
                            </div>

                        </div>
                    </div>
                </div>
                <div class="card card-header-actions mb-4">
                    <div class="card-header">
                        Deskripsi Pekerjaan
                        <i class="text-muted" data-feather="info" data-bs-toggle="tooltip" data-bs-placement="left" title="The post preview text shows below the post title, and is the post summary on blog pages."></i>
                    </div>
                    <div class="card-body">
                        <textarea class="lh-base form-control" type="text" name="description" rows="4"><?= htmlspecialchars($vacancy->description) ?></textarea>
                    </div>
                </div>

            </div>
            <div class="col-lg-4">
                <div class="card card-header-actions">
                    <div class="card-header">
                        Publish
                        <i class="text-muted" data-feather="info" data-bs-toggle="tooltip" data-bs-placement="left" title="After submitting, your post will be published once it is approved by a moderator."></i>
                    </div>
                    <div class="card-body">
                        <div class="d-grid"><button type="submit" class="fw-500 btn btn-primary">Update Lowongan</button></div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<?= $this->endSection(); ?>