<?= $this->extend('company/template/index'); ?>
<?= $this->section('content'); ?>
<?= $this->section('page-css'); ?>
<link href="<?= base_url('../vendor/datatables/dataTables.bootstrap4.min.css') ?>" rel="stylesheet">
<?= $this->endSection(); ?>
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Daftar Lamaran</h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Nama Lowongan</th>
                        <th>Sektor</th>
                        <th>Keahlian Satu</th>
                        <th>Keahlian Dua</th>
                        <th>Minat</th>
                        <th>Total Pelamar</th>
                        <th>Masa Tenggang</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th>No</th>
                        <th>Nama Lowongan</th>
                        <th>Sektor</th>
                        <th>Keahlian Satu</th>
                        <th>Keahlian Dua</th>
                        <th>Minat</th>
                        <th>Total Pelamar</th>
                        <th>Masa Tenggang</th>
                        <th>Aksi</th>
                    </tr>
                </tfoot>
                <tbody>
                    <?php if (is_array($applicants) && !empty($applicants)) : ?>
                        <?php foreach ($applicants as $index => $applicant) : ?>
                            <tr>
                                <td><?= $index + 1 ?></td>
                                <td><?= htmlspecialchars($applicant->placement_address, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($applicant->sector_name, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($applicant->skill_one_name, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($applicant->skill_two_name, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($applicant->interest_name, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($applicant->total_applicants, ENT_QUOTES, 'UTF-8') ?></td>
                                <?php
                                $deadline_time = htmlspecialchars($applicant->deadline_time, ENT_QUOTES, 'UTF-8');
                                $display_text = substr($deadline_time, 0, 10);
                                ?>
                                <td><?= htmlspecialchars($display_text, ENT_QUOTES, 'UTF-8') ?></td>
                                <td>
                                    <a href="<?= site_url('company/vacancies/applicants/' . $applicant->id) ?>"><i class="fas fa-eye"></i></a>
                                </td>

                            </tr>
                        <?php endforeach; ?>
                    <?php else : ?>
                        <tr>
                            <td colspan="10">No data available.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<!-- Page level plugins -->
<?= $this->section('page-js'); ?>
<script src="<?= base_url('../vendor/datatables/jquery.dataTables.min.js') ?>"></script>
<script src="<?= base_url('../vendor/datatables/dataTables.bootstrap4.min.js') ?>"></script>

<!-- Page level custom scripts -->
<script src="<?= base_url('../js/demo/datatables-demo.js') ?>"></script>

<?= $this->endSection(); ?>
<?= $this->endSection(); ?>