<!DOCTYPE html>
<html>

<head>
    <title>Applicants</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" rel="stylesheet">
</head>

<body>
    <div class="container mt-4">
        <h1>Applicants</h1>
        <div class="row">
            <?php if (is_array($applicants) && !empty($applicants)) : ?>
                <?php foreach ($applicants as $applicant) : ?>
                    <div class="card mb-3">
                        <div class="row g-0">
                            <div class="col-md-4">
                                <img src="<?= htmlspecialchars($applicant->profile_photo_url, ENT_QUOTES, 'UTF-8') ?>" class="img-fluid rounded-start" alt="Profile Photo">
                            </div>
                            <div class="col-md-8">
                                <div class="card-body">
                                    <h5 class="card-title"><?= htmlspecialchars($applicant->full_name, ENT_QUOTES, 'UTF-8') ?></h5>
                                    <p class="card-text">Email: <?= htmlspecialchars($applicant->email, ENT_QUOTES, 'UTF-8') ?></p>
                                    <p class="card-text">Address: <?= htmlspecialchars($applicant->address, ENT_QUOTES, 'UTF-8') ?></p>
                                    <p class="card-text">Gender: <?= htmlspecialchars($applicant->gender, ENT_QUOTES, 'UTF-8') ?></p>
                                    <p class="card-text">Age: <?= htmlspecialchars($applicant->age, ENT_QUOTES, 'UTF-8') ?></p>
                                    <p class="card-text">Phone Number: <?= htmlspecialchars($applicant->phone_number, ENT_QUOTES, 'UTF-8') ?></p>
                                    <p class="card-text">Applied At: <?= htmlspecialchars($applicant->applied_at, ENT_QUOTES, 'UTF-8') ?></p>
                                    <?php if ($applicant->status == 'Pending') : ?>
                                        <!-- Jika status adalah Pending -->
                                        <a href="<?= site_url('vacancies/acceptApplicant/' . $companyId . '/' . $vacancyId . '/' . $applicant->id) ?>" class="btn btn-success">Accept</a>
                                        <a href="<?= site_url('vacancies/rejectApplicant/' . $companyId . '/' . $vacancyId . '/' . $applicant->id) ?>" class="btn btn-danger">Reject</a>
                                    <?php elseif ($applicant->status == 'Accepted') : ?>
                                        <!-- Jika status adalah Accepted -->
                                        <p class="card-text text-success">Status: Accepted</p>
                                    <?php elseif ($applicant->status == 'Rejected') : ?>
                                        <!-- Jika status adalah Rejected -->
                                        <p class="card-text text-danger">Status: Rejected</p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>

            <?php else : ?>
                <p>No applicants found.</p>
            <?php endif; ?>
        </div>
    </div>
</body>

</html>