<?= $this->extend('admin/template/index'); ?>

<?= $this->section('content'); ?>

<?= $this->section('page-css'); ?>
<link href="<?= base_url('../vendor/datatables/dataTables.bootstrap4.min.css') ?>" rel="stylesheet">
<?= $this->endSection(); ?>

<!-- Page Heading -->
<!-- DataTales Example -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Verifikasi Pencari Kerja</h6>
    </div>
    <div class="card-body">
        <?php if (empty($data)) : ?>
            <p>No unverified users found.</p>
        <?php else : ?>
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Foto</th>
                            <th>Nama Lengkap</th>
                            <th>Jenis Kelamin</th>
                            <th>Usia</th>
                            <th>No. Telp</th>
                            <th>Pendidikan</th>
                            <th>Minat</th>
                            <th>Kemampuan</th>
                            <th>CV</th>
                            <th>Daftar Pada</th>
                            <th>Kelengkapan</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($data as $index => $dataUser) : ?>
                            <tr>
                                <td><?= $index + 1 ?></td>
                                <td><img src="<?= htmlspecialchars($dataUser->profile_photo_url, ENT_QUOTES, 'UTF-8') ?>" class="img-fluid" alt="Profile Photo" style="max-width: 100px;"></td>
                                <td><?= htmlspecialchars($dataUser->full_name, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($dataUser->gender, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($dataUser->age, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($dataUser->phone_number, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($dataUser->education, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($dataUser->interest_name, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($dataUser->skill_one_name, ENT_QUOTES, 'UTF-8') ?>, <?= htmlspecialchars($dataUser->skill_two_name, ENT_QUOTES, 'UTF-8') ?></td>
                                <td>
                                    <?php if ($dataUser->cv != null) : ?>
                                        <a href="<?= htmlspecialchars($dataUser->cv, ENT_QUOTES, 'UTF-8') ?>" target="_blank"><i class="fas fa-eye"></i></a>
                                    <?php else : ?>
                                        Kosong
                                    <?php endif; ?>
                                </td>
                                <?php
                                $deadline_time = htmlspecialchars($dataUser->created_at, ENT_QUOTES, 'UTF-8');
                                $display_text = substr($deadline_time, 0, 10);
                                ?>
                                <td>
                                    <?= htmlspecialchars($display_text, ENT_QUOTES, 'UTF-8') ?>
                                </td>
                                <td>
                                    <?php
                                    if (is_null($dataUser->cv) || $dataUser->cv == '') {
                                        echo "<span class='badge badge-danger'>Belum Lengkap</span>";
                                    } else {
                                        echo "<span class='badge badge-success'>Lengkap</span>";
                                    } ?>
                                </td>
                                <td>
                                    <div class="d-flex">
                                        <div class="m-2">
                                            <?php if ($dataUser->is_verified == NULL) : ?>
                                                <a href="<?= site_url('admin/activate_user/' . $dataUser->id) ?>" class="btn btn-success btn-sm">Accept</a>
                                            <?php else : ?>
                                                <a href="<?= site_url('admin/activate_user/' . $dataUser->id) ?>" class="btn btn-secondary btn-lg btn-sm disabled" aria-disabled="true">Accept</a>
                                            <?php endif; ?>
                                        </div>
                                        <div class="m-2">
                                            <a href="<?= site_url('admin/disable_user/' . $dataUser->id) ?>" class="btn btn-danger btn-sm">Reject</a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<?= $this->section('page-js'); ?>
<script src="<?= base_url('../vendor/datatables/jquery.dataTables.min.js') ?>"></script>
<script src="<?= base_url('../vendor/datatables/dataTables.bootstrap4.min.js') ?>"></script>
<script src="<?= base_url('../js/demo/datatables-demo.js') ?>"></script>
<?= $this->endSection(); ?>

<?= $this->endSection(); ?>