<?= $this->extend('admin/template/index'); ?>
<?= $this->section('content'); ?>
<?= $this->section('page-css'); ?>
<link href="<?= base_url('../vendor/datatables/dataTables.bootstrap4.min.css') ?>" rel="stylesheet">
<?= $this->endSection(); ?>
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Lowongan Pekerjaan</h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Logo</th>
                        <th>Nama Perusahaan</th>
                        <th>Penempatan</th>
                        <th>Sektor</th>
                        <th>Minat</th>
                        <th>Jenis</th>
                        <th>Tanggal Dibuat</th>
                        <th>Tanggal Berakhir</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th>No</th>
                        <th>Nama Perusahaan</th>
                        <th>Logo</th>
                        <th>Penempatan</th>
                        <th>Sektor</th>
                        <th>Minat</th>
                        <th>Jenis</th>
                        <th>Tanggal Dibuat</th>
                        <th>Tanggal Berakhir</th>
                    </tr>
                </tfoot>
                <tbody>
                    <?php if (is_array($vacancies) && !empty($vacancies)) : ?>
                        <?php foreach ($vacancies as $index => $vacancy) : ?>
                            <tr>
                                <td><?= $index + 1 ?></td>
                                <td><img src="<?= htmlspecialchars($vacancy->company_logo, ENT_QUOTES, 'UTF-8') ?>" class="img-fluid" alt="Logo" style="max-width: 100px;"></td>
                                <td><?= htmlspecialchars($vacancy->company_name, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($vacancy->placement_address, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($vacancy->sector_name, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($vacancy->interest_name, ENT_QUOTES, 'UTF-8') ?></td>
                                <?php if ($vacancy->job_type == 1) {
                                    $job = 'Full Time';
                                } elseif ($vacancy->job_type == 2) {
                                    $job = 'Part Time';
                                } else {
                                    $job = 'Remote';
                                }
                                ?>
                                <td><?= htmlspecialchars($job, ENT_QUOTES, 'UTF-8') ?></td>
                                <?php
                                $deadline_time = htmlspecialchars($vacancy->deadline_time, ENT_QUOTES, 'UTF-8');
                                $created_time = htmlspecialchars($vacancy->created_at, ENT_QUOTES, 'UTF-8');
                                $display_text = substr($deadline_time, 0, 10);
                                $dibuat = substr($created_time, 0, 10);
                                ?>
                                <td><?= htmlspecialchars($dibuat, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($display_text, ENT_QUOTES, 'UTF-8') ?></td>

                            </tr>
                        <?php endforeach; ?>
                    <?php else : ?>
                        <tr>
                            <td colspan="10">No data available.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?= $this->section('page-js'); ?>
<script src="<?= base_url('../vendor/datatables/jquery.dataTables.min.js') ?>"></script>
<script src="<?= base_url('../vendor/datatables/dataTables.bootstrap4.min.js') ?>"></script>

<!-- Page level custom scripts -->
<script src="<?= base_url('../js/demo/datatables-demo.js') ?>"></script>
<?= $this->endSection(); ?>
<?= $this->endSection(); ?>