<?= $this->extend('admin/template/index'); ?>
<?= $this->section('content'); ?>
<!-- <div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-primary">Daftar Perusahaan</h1>
</div> -->
<?= $this->section('page-css'); ?>
<link href="<?= base_url('../vendor/datatables/dataTables.bootstrap4.min.css') ?>" rel="stylesheet">
<?= $this->endSection(); ?>
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Daftar Perusahaan</h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Logo</th>
                        <th>Nama</th>
                        <th>Sektor</th>
                        <th>Alamat</th>
                        <th>Email</th>
                        <th>Terdaftar Pada</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th>No</th>
                        <th>Logo</th>
                        <th>Nama</th>
                        <th>Sektor</th>
                        <th>Alamat</th>
                        <th>Email</th>
                        <th>Terdaftar Pada</th>
                    </tr>
                </tfoot>
                <tbody>
                    <?php if (is_array($companies) && !empty($companies)) : ?>
                        <?php foreach ($companies as $index => $company) : ?>
                            <tr>
                                <td><?= $index + 1 ?></td>
                                <td><img src="<?= htmlspecialchars($company->logo, ENT_QUOTES, 'UTF-8') ?>" class="img-fluid" alt="Profile Photo" style="max-width: 80px;"></td>
                                <td><?= htmlspecialchars($company->name, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($company->company_sector_name, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($company->address, ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($company->email, ENT_QUOTES, 'UTF-8') ?></td>
                                <?php
                                $dibuatPada = htmlspecialchars($company->created_at, ENT_QUOTES, 'UTF-8');
                                $dibuat = substr($dibuatPada, 0, 10);
                                ?>
                                <td><?= htmlspecialchars($dibuat, ENT_QUOTES, 'UTF-8') ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else : ?>
                        <tr>
                            <td colspan="7">No data available.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?= $this->section('page-js'); ?>
<script src="<?= base_url('../vendor/datatables/jquery.dataTables.min.js') ?>"></script>
<script src="<?= base_url('../vendor/datatables/dataTables.bootstrap4.min.js') ?>"></script>

<!-- Page level custom scripts -->
<script src="<?= base_url('../js/demo/datatables-demo.js') ?>"></script>
<?= $this->endSection(); ?>
<?= $this->endSection(); ?>