<?php

namespace App\Models;

use CodeIgniter\Model;
use Exception;

class AdminModel extends Model
{
    protected $baseUrl = 'http://localhost:3000/api';

    public function login($email, $password)
    {
        $client = \Config\Services::curlrequest();

        try {
            $response = $client->post($this->baseUrl . '/admin' . '/login', [
                'form_params' => [
                    'email' => $email,
                    'password' => $password
                ]
            ]);

            $result = json_decode($response->getBody());
            return $result;
        } catch (Exception $e) {
            // Handle exception
            return false;
        }
    }

    public function getAllVacancies($page = 1, $limit = 10)
    {
        $client = \Config\Services::curlrequest();

        try {
            $response = $client->get($this->baseUrl . '/vacancies', [
                'query' => [
                    'page' => $page,
                    'limit' => $limit
                ]
            ]);
            $result = json_decode($response->getBody());
            return $result;
        } catch (Exception $e) {
            return false;
        }
    }

    public function getAllCompanies($page = 1, $limit = 10)
    {
        $client = \Config\Services::curlrequest();

        try {
            $response = $client->get($this->baseUrl . '/companies/all-companies', [
                'query' => [
                    'page' => $page,
                    'limit' => $limit
                ]
            ]);
            $result = json_decode($response->getBody());
            return $result;
        } catch (Exception $e) {
            return false;
        }
    }
    public function getAllUsers($page = 1, $limit = 10)
    {
        $client = \Config\Services::curlrequest();

        try {
            $response = $client->get($this->baseUrl . '/users/all-users', [
                'query' => [
                    'page' => $page,
                    'limit' => $limit
                ]
            ]);
            $result = json_decode($response->getBody());
            return $result;
        } catch (Exception $e) {
            return false;
        }
    }

    public function getTotalCompanies()
    {
        $client = \Config\Services::curlrequest();
        try {
            $response = $client->get($this->baseUrl . '/companies');
            $data = json_decode($response->getBody());
            return $data->totalCompanies;
        } catch (Exception $e) {
            return 0; // Kembalikan 0 jika terjadi error
        }
    }

    public function getTotalVacancies()
    {
        $client = \Config\Services::curlrequest();
        try {
            $response = $client->get($this->baseUrl . '/vacancies');
            $data = json_decode($response->getBody());
            return $data->totalVacancies; // Pastikan key ini sesuai dengan response API Anda
        } catch (Exception $e) {
            return 0;
        }
    }

    public function getTotalUsers()
    {
        $client = \Config\Services::curlrequest();
        try {
            $response = $client->get($this->baseUrl . '/users');
            $data = json_decode($response->getBody());
            return $data->totalUsers; // Pastikan key ini sesuai dengan response API Anda
        } catch (Exception $e) {
            return 0;
        }
    }

    public function getUnverifiedUsers()
    {
        $client = \Config\Services::curlrequest();

        try {
            $response = $client->get($this->baseUrl . '/users/' . 'all-users');
            $result = json_decode($response->getBody());
            return $result;
        } catch (Exception $e) {
            return false;
        }
    }
    public function activateUser($userId)
    {
        $client = \Config\Services::curlrequest();

        try {
            $response = $client->post($this->baseUrl . '/admin/' . $userId . '/activateUser');
            $result = json_decode($response->getBody());
            return $result;
        } catch (Exception $e) {
            return false;
        }
    }
    public function disableUser($userId)
    {
        $client = \Config\Services::curlrequest();

        try {
            $response = $client->post($this->baseUrl . '/admin/' . $userId . '/disableUser');
            $result = json_decode($response->getBody());
            return $result;
        } catch (Exception $e) {
            return false;
        }
    }

    public function getUnverifiedCompanies()
    {
        $client = \Config\Services::curlrequest();

        try {
            $response = $client->get($this->baseUrl . '/companies/' . 'all-companies');
            $result = json_decode($response->getBody());
            return $result;
        } catch (Exception $e) {
            return false;
        }
    }

    public function activateCompany($companyId)
    {
        $client = \Config\Services::curlrequest();

        try {
            $response = $client->post($this->baseUrl . '/admin/' . $companyId . '/activateCompany');
            $result = json_decode($response->getBody());
            return $result;
        } catch (Exception $e) {
            return false;
        }
    }
    public function disableCompany($companyId)
    {
        $client = \Config\Services::curlrequest();

        try {
            $response = $client->post($this->baseUrl . '/admin/' . $companyId . '/disableCompany');
            $result = json_decode($response->getBody());
            return $result;
        } catch (Exception $e) {
            return false;
        }
    }
}
