<?php

namespace App\Controllers;

use App\Models\SkillsModel;
use CodeIgniter\Controller;

class CompanySkillController extends Controller
{
    public function index()
    {
        $judul = [
            'title' => 'Kemampuan',
        ];
        $model = new SkillsModel();
        $data['skills'] = $model->getSkills();

        return view('admin/skills/index', array_merge($data, $judul));
    }

    public function create()
    {
        $judul = [
            'title' => 'Kemampuan',
        ];
        return view('admin/skills/create', $judul);
    }

    public function store()
    {
        $model = new SkillsModel();

        $data = [
            'name' => $this->request->getVar('name')
        ];

        $model->save($data);

        return redirect()->to('admin/skills');
    }

    public function edit($id)
    {
        $judul = [
            'title' => 'Update Sektor Perusahaan',
        ];
        $model = new SkillsModel();
        $data['skills'] = $model->find($id);

        return view('admin/skills/edit', array_merge($data, $judul));
    }

    public function update($id)
    {
        $model = new SkillsModel();

        $data = [
            'name' => $this->request->getVar('name')
        ];

        $model->update($id, $data);

        return redirect()->to('admin/skills');
    }

    public function delete($id)
    {
        $model = new SkillsModel();
        $model->delete($id);

        return redirect()->to('admin/skills');
    }
}
