<?php

namespace App\Controllers;

use App\Models\AdminModel;
use Exception;

class AdminController extends BaseController
{
    public function index()
    {

        if (!session()->get('loggedIn')) {
            return redirect()->to('/admin/login');
        }

        // Tampilkan halaman login jika belum login
        return view('admin/dashboard');
    }

    public function checkAccess()
    {
        $id = session()->get('userId');
        if ($id !== 'd5479df2') {
            session()->destroy();
            // return view('admin/login');
        }
        return true;
    }

    public function dashboard()
    {
        if (!$this->checkAccess()) {
            return view('admin/login'); // if access is denied, stop here
        }
        $judul = [
            'title' => 'Dashboard Admin'
        ];
        if (!session()->get('loggedIn')) {
            return view('/admin/login');
        }

        $model = new AdminModel();
        $totalCompanies = $model->getTotalCompanies();
        $totalVacancies = $model->getTotalVacancies();
        $totalUsers = $model->getTotalUsers();

        return view('admin/dashboard', array_merge($judul, [
            'totalCompanies' => $totalCompanies,
            'totalVacancies' => $totalVacancies,
            'totalUsers' => $totalUsers,
            'chartData' => json_encode([$totalCompanies, $totalVacancies, $totalUsers])
        ]));
    }



    public function vacancies()
    {
        $judul = [
            'title' => 'List Vacancies'
        ];
        $model = new AdminModel();

        $page = $this->request->getGet('page') ?? 1;
        $limit = 10; // Atur jumlah data per halaman

        $data = $model->getAllVacancies($page, $limit);

        if ($data && $data->status == 'Success') {
            return view('admin/vacancies', array_merge($judul, [
                'vacancies' => $data->vacancies,
                'totalPages' => $data->totalPages,
                'currentPage' => $page
            ]));
        } else {
            return view('admin/vacancies', [
                'vacancies' => []
            ]);
        }
    }

    public function users()
    {
        $judul = [
            'title' => 'List Users'
        ];
        $model = new AdminModel();

        $page = $this->request->getGet('page') ?? 1;
        $limit = 10; // Atur jumlah data per halaman

        $data = $model->getAllUsers($page, $limit);

        if ($data && $data->status == 'Success') {
            return view('admin/users', array_merge($judul, [
                'users' => $data->users,
                // 'totalPages' => $data->totalPages,
                // 'currentPage' => $page
            ]));
        } else {
            return view('admin/users', [
                'users' => []
            ]);
        }
    }


    public function companies()
    {
        $judul = [
            'title' => 'List Companies'
        ];
        $model = new AdminModel();

        $page = $this->request->getGet('page') ?? 1;
        $limit = 10; // Atur jumlah data per halaman

        $data = $model->getAllCompanies($page, $limit);

        if ($data && $data->status == 'Success') {
            return view('admin/companies', array_merge($judul, [
                'companies' => $data->companies,
                // 'totalPages' => $data->totalPages,
                // 'currentPage' => $page
            ]));
        } else {
            return view('admin/companies', array_merge($judul, [
                'companies' => []
            ]));
        }
    }



    public function edit($vacancyId)
    {
        $model = new VacancyModel();
        $companyId = session()->get('userId');
        $vacancy = $model->getVacancyById($companyId, $vacancyId);

        if ($vacancy) {
            return view('vacancy_edit', ['vacancy' => $vacancy]);
        } else {
            return redirect()->to('/vacancies'); // Redirect to the listing page if vacancy not found
        }
    }

    public function update($vacancyId)
    {
        $model = new VacancyModel();
        $companyId = session()->get('userId');

        $data = $this->request->getPost();
        $result = $model->updateVacancy($companyId, $vacancyId, $data);

        if ($result) {
            // handle success
        } else {
            // handle error
        }

        return redirect()->to('/vacancies');
    }

    public function applicant()
    {

        if (!session()->get('loggedIn')) {
            return redirect()->to('/login');
        }

        // Tampilkan halaman login jika belum login
        return view('admin/applicant');
    }

    public function profile()
    {

        if (!session()->get('loggedIn')) {
            return redirect()->to('/login');
        }

        // Tampilkan halaman login jika belum login
        return view('admin/profile');
    }

    public function checkUsers()
    {
        $judul = [
            'title' => 'Verif Users'
        ];
        $adminModel = new AdminModel();
        $data = $adminModel->getUnverifiedUsers();

        if ($data) {
            return view('admin/verify_users', array_merge($judul, [
                'data' => $data->users
            ]));
        } else {
            return view('admin/verify_users', [
                'data' => []
            ]);
        }
    }

    public function activateUser($userId)
    {
        $model = new AdminModel();
        $data = $model->activateUser($userId);
        if ($data) {
            return redirect()->to(site_url('admin/verify_users'))->with('message', 'User activated successfully');
        } else {
            return redirect()->back()->with('error', 'an error occured');
        }
    }
    public function disableUser($userId)
    {
        $model = new AdminModel();
        $data = $model->disableUser($userId);
        if ($data) {
            return redirect()->to(site_url('admin/verify_users'))->with('message', 'User disable successfully');
        } else {
            return redirect()->back()->with('error', 'an error occured');
        }
    }
    public function checkCompanies()
    {
        $judul = [
            'title' => 'Verif Company'
        ];
        $adminModel = new AdminModel();
        $data = $adminModel->getUnverifiedCompanies();

        if ($data) {
            return view('admin/verify_companies', array_merge($judul, [
                'data' => $data->companies
            ]));
        } else {
            return view('admin/verify_companies', [
                'data' => []
            ]);
        }
    }

    public function activateCompany($userId)
    {
        $model = new AdminModel();
        $data = $model->activateCompany($userId);
        if ($data) {
            return redirect()->to(site_url('admin/verify_companies'))->with('message', 'Company activated successfully');
        } else {
            return redirect()->back()->with('error', 'an error occured');
        }
    }
    public function disableCompany($userId)
    {
        $model = new AdminModel();
        $data = $model->disableCompany($userId);
        if ($data) {
            return redirect()->to(site_url('admin/verify_companies'))->with('message', 'Company activated successfully');
        } else {
            return redirect()->back()->with('error', 'an error occured');
        }
    }
}
